"Randomized escape" by Yvan Uhlmann




Section 1 - Main Rules

[This first rule is the most important of all, because a randomizer can't consider the name propety (or noun) as fundamental.
Instead, it needs Haecceity: the possibility to differenciate two objects on the sole basis that those two objects are two distinct objects.
This was done by considering the noun as a fundamental property - some sort of index number - and the printed name as the name property.
The following rule made it possible to still refer to objects by saying their name instead of their Haecceity/index number/noun.
Later, another property (title2) will ]
Understand the printed name property as describing a thing.
Understand the printed name property as describing a room.

[For rando]
An object can be placed or non-placed.
An object is usually non-placed.

[This is to force players to examine]
Every object can be examined or non-examined.
An object is usually non-examined.
Carry out examining something (called X):
	if X is non-examined:
		now X is examined;
	if X is examined:
		continue the action.

[This is to regulate encounters]
Every thing can be haunted or non-haunted.
A thing is usually non-haunted.
Every thing can be lucky or unlucky.
A thing is usually unlucky.

[This is to hide]
An object can be hidden or revealed.
An object is usually revealed.

[This is to hide unviable objects]
Before listing nondescript items:
	repeat with T running through the list of every marked for listing thing:
		if T is hidden:
			now T is not marked for listing.


[Improve comprehension]
Understand "go to [something]" as examining.
Understand "walk to [something]" as examining.
Understand "walk to [a direction]" as going.
Understand "walk [direction]" as going.
Understand "inspect [something]" as examining.
Understand "explore [something]" as examining.
Understand "search [a direction]" as examining.
Understand "search for [something]" as examining.
Understand "search in [something]" as examining.
Understand "search around [something]" as examining.
Understand "look for [something]" as examining.
Understand "look around" as looking.
Understand "enter in [something]" as entering.
Understand "search for clues" as helping.


[Searching]
Instead of searching something:
	try examining the noun.
	
[Entering]
A thing can be vehiculable or non-vehiculable.
A thing is usually non-vehiculable.
Instead of entering something (called X):
	if X is vehiculable:
		try examining X;
	otherwise:
		if X is the rusty door:
			continue the action;
		otherwise:
			say "I cannot enter [the X].".
			
[Driving]
Understand the command "drive" as something new.
Understand "drive [something]" as driving.
Driving is an action applying to one thing.
Carry out driving something (called X):
	if X is vehiculable:
		try examining X;
	otherwise:
		say "I cannot drive [the X].".

[Opening]
A thing can be openable or unopenable.
A thing is usually unopenable.
A container is openable.
A door is openable.
Instead of opening something (called X):
	if X is openable:
		try examining X;
	otherwise:
		say "There does not seem to be anything I can open on the [X].".

[Reading]
A thing can be readable or non-readable.
A thing is usually non-readable.
Understand the command "read" as something new.
Reading is an action applying to one thing.
Understand "read [something]" as reading.
Carry out reading something (called X):[for readables]
	if X is readable:
		try examining X;
	otherwise:
		say "There is nothing on the [X] that I can read.".

[Siting]
Understand the command "sit" as something new.
Understand "sit down on [something]" or "sit on [something]" or "sit up on [something]" as sitting down.
Sitting down is an action applying to one thing.
Carry out sitting down something (called X):
	if the printed name of X is "bench":
		say "There is no time to waste siting on that bench. I just want to be out of here. I should search for clues instead of lazing around.";
		try examining X;
	otherwise:
		say "I have no reason to sit there. I just want to be out of here.".

[Lighting]
Understand the command "light" as something new.
Lighting is an action applying to nothing.
Understand "light" or "lit" as lighting.
Carry out lighting:
	if the player is carrying a lighter:
		say "I do not want to waste gas lighting things on fire for no reason.";
	otherwise:
		say "I have nothing to light.".

[Lighting smthing]
Lightsomething is an action applying to one thing.
Understand "light [something]" or "lit [something]" as lightsomething.
Carry out lightsomething:
	if the player is carrying a lighter (called X) and present gas of X is not 0:
		say "I do not want to waste gas lighting things on fire for nothing.";
	otherwise:
		say "I have nothing to light it with.".

[Using]
Understand the command "use" as something new.
Understand "use [something]" as using.
Using is an action applying to one thing.
Carry out using something (called X):
	if the player is carrying X:
		if X is a lighter and present gas of X is not 0:
			say "I would rather keep the gas for life-threatening situations.";
		if X is a lighter and present gas of X is 0:
			say "This lighter is out of gas. I might as well throw it. You throw the lighter away.";
			now X is nowhere;
			now X is non-placed;
		if X is readable:
			try examining X;
		if X is a knife:
			say "I… I would rather never use that.";	
	otherwise:
		if X is readable:
			try examining X;
		if X is vehiculable:
			say "Do you want me to try to enter the vehicule, or examine it maybe?";
		if X is not readable and X is not vehiculable:
			say "Do you want me to examine the [noun]?".

[Drinking]
Instead of drinking something (called X):
	if the printed name of X is listed in {"coffee cup"}:
		say "Taking this garbage left on the pavement, put it on my lips and drink what is inside of it? What kind of depraved human am I becoming? I am not thirsty, and I really do not need a few droplets of dust and unknown bacteria.";
		try examining X;
	otherwise:
		say "There is nothing for me to drink near the [noun].".

[Smoking]
Understand the command "smoke" as something new.
Understand "smoke [something]" as smoking.
Smoking is an action applying to one thing.
Instead of smoking something (called X):
	if the printed name of X is listed in {"cigarette end"}:
		say "Smoking from an old cigarette end left on the ground? What am I thinking of?";
		try examining X;
	otherwise:
		say "There is nothing for me to smoke near the [noun].".

[Help]
Understand the command "help" as something new.
Understand "help" as helping.
Helping is an action applying to nothing.
Carry out helping:
	say "Alone in the middle of this living nightmare, you took a few seconds to think.[line break] A way out. Some clues. The threats. The darkness. I could use a lighter. A radio. Something to defend myself. Something to call for help.[line break] There will not be any help. I should not stop searching, exploring, anything could help in this misery. If it’s not here. Let’s hope it is in a street nearby up North or down South.".

[Rule to invite players for directions]
After examining something (called X) in ro1city:
	let L be a list of things;
	repeat with T running through everything revealed in ro1city:
		if T is non-examined, add T to L;
	if the number of entries in L is 1:
		if X is unlucky:
			say "I have inspected everything in this [location]. [one of]This city is giving me shivers, but I must go on. Maybe I will find something useful somewhere else. I will. I have to. I will get out of here.[or]Why would I even spend time searching garbage in here? What have I done to deserve this? Let’s focus. I will probably find something useful somewhere else.[or]Am I going to spend all my time digging in trashes? Let’s move and try to find something useful in this City. [at random][no line break]I should not stay in some place for too long. I have to go, but in which direction?";
			stop the action;
		if X is lucky:
			say "I am glad that I did not search all that garbage for nothing. I will not get me out of this city yet. I need to continue my investigation. I need to go in some other places in this city. But in which direction should I go? I am totally lost.";
			stop the action;
	otherwise:
		continue the action.

[For beta testing]
Understand "* [text]" as a mistake ("Noted.").
		
[This is to make death unreversible]
Use UNDO prevention.






Section 2 - Sanity

[Define sanity]
A person has a number called max sanity.
A person has a number called present sanity.
The max sanity of a person is usually 6.
The present sanity of a person is usually 6.

[function to decrease sanity and provoke death]
To decrease sanity:
	let X be the present sanity of the player;
	let Y be X - 1;
	now the present sanity of the player is Y;
	if the present sanity of the player is less than 1:
		die.

[Enable show sanity]
Showing sanity is an action applying to nothing.
Carry out showing sanity:
	let X be the present sanity of the player;
	if X >= 3:
		if X >= 5, say "[one of]This town is creeping me out, but I will carry on.[or]I have the strength to continue.[purely at random]";
		otherwise:
			say "[one of]What are those things and what do they want from me? I am scared[or]I, I still know who I am. I still can make it. I think.[purely at random]";
	if X <= 2:
		say "[one of]I. I am. Who am I? What am I even doing in here? Stop this, stop it now.[or]This town. I am getting mad. I am. This town. Get me out of here. Now.[purely at random]";
		decrease sanity.

[Understanding]
Understand "what is my sanity" or "check sanity" or "what is my current sanity" or "examine sanity" or "examine player" or "current sanity" or "sanity" or "Am I ok" as showing sanity.







Section 3 - Endgames

[Very bad]

To murder:
	say "[line break]But you are so weak. You stumble. Your lungs burn. You always knew you had to face it one day.[line break]Get away from me! you screamed. You are dead! You are dead! but she runs at you, in a piercing cry of joy and anger. She beats you to the ground and claw your face off. You try to protect yourself but you know this is the end. You give your last efforts to turn around and start to crawl. The streets are slowly disappearing and the sounds too. You still feel the scratch in your back. Her screams are almost inaudible now. The warm sensation of pain is fading away. Your jaw relaxes. Your face on the ground. You are leaving away. Soon, the city will be back into its deep and dark silence. Just like you were, and you could not do anything to stop it.";
	end the story saying "Worst ending.".

[Bad]
To die:
	say "[line break][one of]The world around you seems to turn down into a spiral. He was never right. This is all just a masquerade. This is all just a masquerade! Your body fall on the ground as you laugh louder and louder. In the distance, your screams disperse. Soon, the city will be back into its deep and dark silence.[or]It cannot be... It cannot be...[line break]Your body fall down in a puddle. Lying down on the pavement, it almost seems like you finally found a peaceful rest. You never knew why you came here, but you will stay there, for ever.[or]You hear a sound behind you. Nobody. Again. Where are you? You turn in random directions, feeling threats all around you. Then all of these phantoms slowly surround you, grab your body and push you down to the ground. You try to resist with all your strength, but it is not enough. Soon, you will lay down in the puddles, and the streets will be silent again.[purely at random]";
	end the story saying "Bad ending.".
		
[Middle]
To kill:
	say "The thing has blood all over her body. She is limping towards you. It seems that she could fall at any moment. You firmly grasp your knife and raise your chin. You slowly walk towards to meet her, but as you come closer, she falls on the ground in a last moan. Sleep tight Lily.[line break] As her blood flows between the pavements, you can hear a long, grievous complain coming from the ground. The ground starts shaking and the fog all around you turns red. The body of the thing slowly vanish with the fog. The ground shake. What is happening? You scream as everything turn into a dazzling white.[line break]After this moment of cataclysm, the clouds drift away, and you open your eyes as the sunlight fills the streets. You can clearly see the City, its streets, the abandoned cars, the closed shops. In the distance, you see a hill.[line break] Birds are singing as you walk on the road towards the hill. You look in the direction of these sounds. A few carcasses decaying. The birds must have gone away.";
	end the story saying "You escaped with blood on your hands.".

[Good?]
To escape:
	say "[line break]The soft, tender screams of this abyss. What I have done is nothing. My accession is impending. Reality. As I walk down into darkness I will crush you from above, and the sparkling tones of your fractures. Rhythm to my own joy. Goodbye old world.[line break]You pull the rusty door as hard as you can. With its creeks come a million voices of pain and delight in a wind so strong you handle firmly to the door. The wall cracks and the hinges are torn apart. The door heavily slams on the floor. A grandiose dazzling light is coming out of it.[line break][line break]The fluorescent light burn your eyes but you keep them wide open. You slowly walk forward into the light[line break] [line break]The door slams back on the wall like if it was sucked from a void. The fog soon covers it, and the street is back into silence. But something, somewhere, is now waiting. One day, in the common everyday life of our streets, the unreal will reveal. Until then, the streets will remain silent, and the door shut.";
	end the story saying "Good ending".







Section 4 - The City

[Set regions]
the City is a region.
a ro1city, a ro2city, a ro3city, a ro4city, a ro5city, a ro6city, a ro7city, a ro8city, a ro9city are in the City.

[Set a certain number of rooms for City]
a ro1city, a ro2city, a ro3city, a ro4city, a ro5city, a ro6city, a ro7city, a ro8city, a ro9city are rooms.

[Randomly map rooms and avoid overwritting]
To make City links:
	now ro1city is placed;
	[1. This will force the second loop until all rooms are paced]
	while the list of non-placed rooms in the City is not empty:
		[2. part for each ending room]
		repeat with Rentrance running through non-placed rooms in the City:
			[3. part for random starting room]
			let L be the list of placed rooms in the City;
			let X be a random number between 1 and the number of entries in L;
			let Rexit be the entry X of L;
			[4. part for random direction]
			[Can't use the variable 'let M be a random direction' in 'now a random room in the City is mapped M of Rext.']
			[Also, you might think that this is the appropriate place for the 'while unplaced' loop. It is not, because
			if a room is mapped n, s, e, w, then it will loop forever. You will then have to take another Rexit, and that is
			exactly what the current loop 1 is doing.]
			let Y be a random number between 1 and 4;
			if Y is: 
				-- 1: 
					if the room north from Rexit is nothing:
						now Rentrance is mapped north of Rexit;
						now Rexit is mapped south of Rentrance;
						now Rentrance is placed;
				-- 2:
					if the room south from Rexit is nothing:
						now Rentrance is mapped south of Rexit; 
						now Rexit is mapped north of Rentrance;
						now Rentrance is placed;
				-- 3:
					if the room west from Rexit is nothing:
						now Rentrance is mapped west of Rexit; 
						now Rexit is mapped east of Rentrance;
						now Rentrance is placed;
				-- 4:
					if the room east from Rexit is nothing:
						now Rentrance is mapped east of Rexit;
						now Rexit is mapped west of Rentrance;
						now Rentrance is placed.

[City Rooms Names]
[The 'random order' option is distributed when the assignment is made, not when the in-game action is done.]
Table of Rooms in City
name	description
"Unnamed Street"	"[one of][feelingly] You feel a small breeze grasping your neck and slowly turn your head with the unpleasant sensation of a presence by your side. It is a wide-open street, but each side of it is firmly closed by tall dwellings. Walls full of holes, broken glass, barricaded doors. What the hell am I doing here? Stay focus. Stay calm. Got to find a way out of here.[or]You walk forward in the open. The road is dark. The buildings are too. Your mind... your mind. Am I going to get it back once?[at random]"
"Unnamed Street"	"You walk on the pavement of this unknown street and notice some birds on the other side of the street. As you leave the sidewalk and walk accidently on broken glass, the group of pigeons suddenly stop pecking and stare at you. You make your way through the fog as the birds fly away. You discover what seems to be the rests of another pigeon. [feelingly] You turn around, facing the street, wondering what is going to be next."
"Unnamed Road"	"You wander along the road without a clue. There is still some paint left on it, a triangle symbol indicating a nearby school. You can still clearly read the ‘slow down’ injunction, although there is no car driving along, nor school located nearby. [feelingly] Constructions are getting sparse. You cannot see any obvious issue through the fog. [italic type]There is no time for hesitating. I have to think straight.[roman type]"
"Unnamed Alley"	"This alley is pretty narrow. Garbage on the ground is preventing you from walking straight. [feelingly] For a moment you thought you see something move in front of you. This alley starts to frightens you. Your pace is getting faster, so is your heartbeat. A noise in your back – you turn around in a flash. Immobile in the middle of the alley, you look back carefully, waiting for something to come out of the fog. But nothing came. You take a deep breath and your heartbeat stabilize.”
"Unnamed Alley"	"You walk through an alley, looking at the high walls surrounding you. [feelingly] Stones, bricks, concrete, a patchwork of discordant constructions. [line break] You walk forward until a brighten spot. It is almost like if you felt reassured for a moment."
"Unnamed Alley"	"As you walk deeper into the darkness of the narrow alley, you notice some kind of smoke coming up from the ground. Your pace increase as the ground seems to disappear into some deep thick grey smog. You run in dread until the strange phenomena slowly cease. You wonder in great exhaustion: was that a sorcerous force? Was that just the effect of dust under my feet? You come back a few steps to try both hypotheses, but the nameless force does not show up anymore. You will probably never now."
"Residential area"	" Broken windows, open doors, painting coming off the wooden walls. Houses on both side of the street seem abandoned. Who would ever want to live here anyway."
"Residential area"	"You are surrounded by gray residential blocks. As you walk forward on this lonely road, you scrutinize every floor, every window, every balcony in search of a living being."
"Vacant lot"	"Around the corner, you ended up in a vacant lot. It has enough space for an amusement park, serves as a junkyard, and looks like a battlefield. The uneven ground makes you think about these hills, where you were born. [feelingly]"
"Industrial park"	"You are walking along warehouses of the size of a football field. There still are some brands painted on their front door, but they do not ring a bell. The doors seem to be strongly closed by heavy padlocks and chains. You want to enter one to see what you could loot inside, but as you come closer to that particular one, a sudden noise comes from inside the warehouse. You walk quickly back from where you came, in the open. You stop there and wonder if you want to take the risk to stay longer in this area."

[Assigning a Name to each Room in the City]
To make City:
	repeat with R running through rooms in the City:
		choose a random row in the Table of Rooms in City;
		now the printed name of R is "[name entry]";
		now the description of R is "[description entry]".








Section 5 - Items

[General property]
A thing can be cityItem.
A thing is usually not a cityItem.

[Lighters]
A lighter is a kind of thing.
A lighter has a number called max gas.
A lighter has a number called present gas.
The max gas of a lighter is 3.
The present gas of a lighter is usually 3.
a Li1, a Li2, a Li3 are lighters.
a Li1, a Li2, a Li3 are cityItem.

[Improve comprehension]
Understand "lighter" as Li1 or Li2 or Li3 or Li4. [Li4 is in brick hole]

[Sadly can't vary lighter color here]
To make cityLighters:
	now the printed name of Li1 is "magenta lighter";
	now the description of Li1 is "A lighter! That sure will be usefull.";
	now the present gas of Li1 is a random number between 1 and 3;
	now the printed name of Li2 is "crimson lighter";
	now the description of Li2 is "This lighter looks [judgmently], but it sure will help me in this town.";
	now the present gas of Li2 is a random number between 1 and 3;
	now the printed name of Li3 is "ochre lighter";
	now the description of Li3 is "Finally something usefull! If only it could never run out of gas.";
	now the present gas of Li3 is a random number between 1 and 3.

After examining a lighter (called X):
	say "[no line break][no line break]You shake the lighter and [if present gas of X is 3]discover that it is full. What a luck![end if][if present gas of X is 2]guess that it is more than half full.[end if][if present gas of X is 1]realize that it is soon empty. Let's get out of here quick.[end if][if present gas of X is 0]realize that it is empty. I need to find a way out, quick.[end if]".

[Torn letter]
A torn letter is a thing.
A torn letter is cityItem.
A torn letter is readable.
The description of the torn letter is "Most of the text is gone, buy you can still read the following:[line break]
[']It was golden and splendid, That City of light;[line break]
A vision suspended In deeps of the night;[line break]
A region of wonder and glory, whose temples were marble and white.[line break]
[line break]
Its mansions were stately With carvings made fair,[line break]
Each rising sedately On terraces rare,[line break]
And the gardens were fragrant and bright with strange miracles blossoming there.[line break]
[line break]
I fann'd the faint ember That glow'd in my mind,[line break]
And strove to remember The aeons behind;[line break]
To rove thro['] infinity freely, and visit the past unconfin'd.[line break]
[line break]
Then the horrible warning Upon my soul sped[line break]
Like the ominous morning That rises in red,[line break]
And in panic I flew from the knowledge of terrors forgotten and dead.[']"

[Knifes]
A knife is a kind of thing.
A knife is cityItem.
a Kn1 is a knife.
The printed name of a Kn1 is "compact knife".
The description of a Kn1 is "I. I would rather not think about it.".
a Kn2 is a knife.
The printed name of a Kn2 is "sharp knife".
The description of a Kn2 is "I. I would rather not think about it.".

[Improve comprehension]
Understand "knife" as Kn1 or Kn2.

[A picture]
An old portrait is a thing.
An old portrait is cityItem.
The description of an old portrait is "The girl on the picture has short red hairs. On the back is an inscription:[line break][']I will wait you until the storm pass by; but if I were to pass before the storm, you will find the key to my heart under the red pole in our jewelry box.['][line break] There are not much information on the location of that box, but I sure wish I could find it.".

[Because of the description of the picture]
Understand "red pole" as the jewelry box.

[A piece of paper]
A piece of paper is cityItem.
A piece of paper is readable.
The description of a piece of paper is "The paper is torn and folded in many ways, but you can still read the following words:[line break]
[']...as I have always trust you as my friend.[line break]
...times, I just cannot see any other alternative. If you...[line break]
...know what I am like when I am angry. This is...[line break]
...I left it under the statue in [location of the wooden box]. Please, do not...[line break]
...and I will always be.['][line break]
It is signed with the letter [']D['].[line break]
Where could this statue be?
".

[Because of the description of the wooden box]
Understand "statue" as the wooden box.

[A postcard]
A postcard is cityItem.
A postcard is readable.
The description of a postcard is "It is a postcard from Budapest. It is partly burnt. On the back, you can still read:[line break]
[']...enjoying this summer even at...[line break]
...although I am not sure if you can...[line break]
...left it in the hole next to Warren Street shop door...[line break]
...into this [location of the brick hole] were we first ...[line break]
...you very soon.['][line break]
You cannot see the signature on it.[line break]
Could this refer to a place nearby?
"

[Because of the description of the wooden box]
Understand "Warren Street shop door" or "Warren Street shop" or "Warren Street" or "shop" as the brick hole.

[A parchment]
A parchment is cityItem.
A parchment is readable.
The description of a parchment is "There is a poem written on this page:[line break]
[']The thing, he said, would come in the night at three[line break]
From the old churchyard on the hill below;[line break]
But crouching by an oak fire's wholesome glow,[line break]
I tried to tell myself it could not be.[line break]
[line break]
Surely, I mused, it was pleasantry[line break]
Devised by one who did not truly know[line break]
The Elder Sign, bequeathed from long ago,[line break]
That sets the fumbling forms of darkness free.[line break]
[line break]
He had not meant it - no - but still I spoke[line break]
The cursed words in the [location of the rusty door].[line break]
Out of the Seekonk, my fists clenched,[line break]
['][']B'gnu-Thun[']['] I screamed, and the fog faded.[line break]
[line break]
Then at the door that cautious rattling came -[line break]
And the mad truth devoured me like a flame!['][line break]
As you finish these verse, a cold breeze caress your hairs. You can hear the sound of leaves dancing in the wind, but the fog does not weakens.
"

[A piece of paper]
A small note is cityItem.
A small note is readable.
Understand "note" as the small note.
The description of a small note is "There is something written on this short note:[line break]
[']They should have never done it.[line break]
I am with you brother.[line break]
In our father[']s Cadillac,[line break]
Push the plastic frame under the steering wheel.[line break]
I[']ll be with you when you[']ll do it.[line break]
Be strong brother.[']
".
After examining the small note:
	if the car is non-examined:
		say "What is wrong with the people here. This sounds like a death note. Anyway, the addressee probably never got that note. Whatever is in this Cadillac, he never got it.";
		now the note is examined;
	otherwise:
		say "Wait, I already saw a Cadillac. Where was it already? There is nothing reassuring about this note. Better get to this item before the addressee finds it first.";
		now the note is examined.



[Place a limited number of things in City]
To place cityItems:
	[This will force every items to have a chance to be placed]
	repeat with T running through the list of every cityItem things:
		[{Li4, Kn1, Kn2} are in containers]
		if T is not listed in {a Li4, a Kn1, a Kn2}:
			[There thus is the possibility that the player never gets a cityItem: because its presence is 1/3 on every cityItem + 1/7 on ever cityDecor]
			if a random chance of 1 in 15 succeeds:
				let roA be a random room in the City;
				now T is in roA;
				now T is placed.









Section 6 - Containers

[A jewely box]
A jewelry box is a container.
A jewelry box is hidden.
Inside the jewelry box is a rotten key.
The description of the rotten key is "A strange sensation grasp your hand as you look at the key in your palm. You quickly put it back in your pocket and examine your hand. The red, burning skin seems to fade away. Soon, the sensation is gone and your hand is back to normal.[line break] You stumble a bit, and realize you have been looking into the void for minutes now. You are at the other end of [the location of the player]. You walked blindly. Let's leave this key for now.".
The rotten key unlocks the rusty door.
Instead of examining the jewelry box:
	if the jewelry box is non-examined:
		say "You look around for a red pole, as described on the picture you found. After a while, you notice a street lamp painted in red. This must be it. The only thing around the streetlamp is a trash. You are not losing hope and start to dig in the bin. Your efforts have paid off as you discover a jewelry box.";
		now the jewelry box is revealed;
		continue the action;
	otherwise:
		continue the action.
		
[A wooden box]
A wooden box is a container.
A wooden box is hidden.
Inside the wooden box is a Kn2.
The Kn2 is placed.
Instead of examining the wooden box:
	if the wooden box is non-examined:
		say "You wander a bit in the [location] and notice a small statue through the fog. This must be it. You find a wooden box hidden behind the statue.";
		now the wooden box is revealed;
		continue the action;
	otherwise:
		continue the action.

[A brick hole]
A brick hole is a container.
A brick hole is hidden.
Inside the brick hole is a Li4.
A Li4 is a lighter.
The Li4 is placed.
The printed name of a Li4 is "golden lighter".
The description of Li4 is "Someone left this lighter in a brick hole.".
The present gas of Li4 is 3.

Instead of examining the brick hole:
	if the brick hole is non-examined:
		say "You walk to the closest intersection near the [location] and discover that you are on Warren Street. You start walking along, looking for the first shop you could find. But there seems to be none. Wait. You cross the road toward a building with its first floor fortified with barricades. There is a [']Open['] sign on the ground. This must be the store from the postcard. There is a hole at the bottom right of the door. You go on your knees and look into the brick hole.";
		now the brick hole is revealed;
		continue the action;
	otherwise:
		continue the action.

[A wooden box]
A car is a container.
A car is vehiculable.
Inside the car is a Kn1.
The Kn1 is placed.
Instead of examining the car:
	if the small note is non-examined:
		if the car is non-examined:
			say "[one of]Well is it not a fine Cadillac? I always wanted to have one of those. I mean, before. Before I am here. Since when am I here? What have I done yesterday? Please keep calm, please keep calm. The car, the car.[or]You walk closer to the car and decide to take a few steps around it to admire its beauty. I always wanted a Cadillac, you say to yourself, but after a little while, the brightness fades out, and the impurities of the car become more and more self-evident.[or]An Eldorado, the most beautiful of all Cadillacs. You walk toward the car of your dreams, realizing a sudden contrast between your dreams and your current position. What have I done to… Do I deserve all of this? You walk toward the car with a hand on the side of your head, as if something was too heavy to carry.[at random]";
			say "Surprisingly, the front door opens without any effort. You start to search inside the car. You open the glove box, look under the seats, each one of them. Your search reveals unfruitful after a few minutes spent in this stinky car. You get outside and look at the Cadillac as it was a sign of your lost past.";
			now the car is examined;
		otherwise:
			say "The Cadillac... I. I am doomed. You walk away from this disturbing sight of your peaceful path.";
	otherwise:
		if the player is not carrying Kn1:
			say "A Cadillac! Just like in the note I read. You enter the Cadillac and look under the steering wheel. A frame, this must be it. You start to push on each side of the frame, looking for a way to dismantle it. Suddenly, you ear a crackle and the plastic frame opens. A knife. You stare at it for a moment. You are afraid of this town, of its people, and of yourself, being tempted to take the knife with you. You slowly reach for it, and exit the car. You walk away from it with a blank mind. What is going to happend next?";
			now the player is carrying Kn1;
		otherwise:
			say "This Cadillac. The knife. Stay strong."

[Hide the content of the car but not the car itself]
Rule for printing the name of the car:
	say "[printed name of the car]";
	omit contents in listing.


[Randomly place containers]
To place containers:
	repeat with T running through the list of every containers:
		let Ro be a random room in the City;
		now T is in Ro.









Section 7 - Decors

[Known curiosities: decors are non-placed because multiple.]

[City decor]
A cityDecor is a kind of thing.
[There is max five cityDecor per room. For nine rooms: 45]
a cD1, a cD2, a cD3, a cD4, a cD5, a cD6, a cD7, a cD8, a cD9, a cD10, a cD11, a cD12, a cD13, a cD14, a cD15, a cD16, a cD17, a cD18, a cD19, a cD20, a cD21, a cD22, a cD23, a cD24, a cD25, a cD26, a cD27, a cD28, a cD29, a cD30, a cD31, a cD32, a cD33, a cD34, a cD35, a cD36, a cD37, a cD38, a cD39, a cD40, a cD41, a cD42, a cD43, a cD44, a cD45 are cityDecors.
A cityDecor is fixed in place.

[Place decor in City]
To place cityDecors:
	let L be the list of every cityDecor;
	let N be 1;
	repeat with R running through rooms in the City:		
		[P for minimum of 2 decors per room]
		repeat with P running from 1 to 2:
			let M be entry N of L;
			now M is in R;
			increase N by 1;
		[P for possible 3 to 5 objects per room]
		repeat with P running from 1 to 3:
			if a random chance of 2 in 5 succeeds:
				let M be entry N of L;
				now M is in R;		
				increase N by 1.

[City Decors Names]
[By cheer luck, the 'random order' option in descriptions is distributed when the random assignment is made, not when the in-game action is done.]
Table of City Decors
name 	title2	title3	 description
"car tire"	"tire"	"tire"	"[one of]A car tire is laying on the ground. This city is a mess.[or]The car tire on the left of the street as some [citycolorly] reflects. It does makes it poetic thaugh.[or]Someone had to change his tire, and left the old one in the streets. Maybe he thought that these things are degradable.[or]A car tire was left here. It seems of no use, and there is nothing around it.[in random order]"
"fire hydrant"	"hydrant"	"fire"	"[one of]A fire hydrant just like the others. You walk around it in search of something useful, but could not find anything.[or]I am [adverbly] sure that this hydrant does not work. I mean, have you saw the decrepitude of this City?[or]This hydrant probably was red before turning [citycolorly] because of the atmosphere. Is this fog due to pollution? It does not smell bad though. It smells, it actually smells nothing. Am I dreaming? Keep focus, search for clues.[in random order]"
"bench"	"seat"	"seat"	"[one of]Just a usual bench like every town.[or]A [colorly] bench. It must been a while since someone sat on it.[or]Who would sat on this [judgmently] bench? Anyway, there is nothing useful here.[or]This [citycolorly] bench is so dirty that I would much rather stay still.[in random order]"
"tree"	"wood"	"plant"	"[one of]A [sizely] tree in the middle of an industrial town. It has some graffitis on it.[or]How could this [sizely] tree still be alive in this [judgmently] city? There seem to be nothing of use around here.[or]I was not expecting this [judgmently] city to have a single tree. You walk around the tree, searching for something left hanging on its branches, but there was nothing there for you.[or]There is a [sizely] tree on the other side of the road. Its leaves seem covered by dust. There is nothing interesting here.[in random order]"
"car"	"car"	"vehicule"	"[one of]It is a [judgmently] [colorly] car. Someone parked it on the side of the road. The doors are locked and you cannot see anything inside. Let's look somewhere else.[or]This [colorly] car is [judgmently]. You put your hand on the driver's door handle and realize that it is slippery. Some kind of thick black oil is running down your hand. You walk back from the car and find a puddle to clean you. This car must have been abandoned here forever. Let's search somewhere else.[or]My uncle used to have a similar car. It is just as [judgmently] as his. You wander around the car, remembering your uncle. You look through the windows, try the doors. This car will not help me, just like my uncle.[or]This car is [adverbly] disgusting. You walk toward the car to try opening it, but realize it already was vandalized. A window is broken, and the interior fittings were left in disorder. It is useless to search around here.[in random order]"
"SUV"	"sport utility vehicle"	"vehicule"	"[one of]It is a [colorly] SUV. Windows are black tinted. It looks [judgmently]. You try to open every door but the car is locked. [or]The [judgmently] SUV is parked in the middle of the sidewalk. You try to open the driver door but a loud bip occurs. The contrast of this noise with the unbroken silence of the streets frightened you. What if someone heard it? What if you really do not want to meet this someone? You take a few steps back and look carefully around you for visitors. Thankfully, there is no one here. I better leave this SUV alone.[or]Tell me that it is open. Tell me that the keys are in. Tell me that I can drive straight out of this city. You turn around the SUV, trying to open its doors and looking through the windows. But none opened. You swear to avoid abandoning yourself in such hopeless dreams in the future. You turn around from the locked SUV and look for other clues.[in random order]"
"mini-van"	"van"	"mini van"	"[one of]I remember dreaming about these mini-vans when I was a teenager. Also, the ones in my dreams where not [judgmently]. You approach the mini-van and realize that a door is missing. You are soon discouraged to have a look inside, because of the smell coming from it. The smell of rotten food, abandoned years ago. You walk away from the van but the smells still disturb you.[or]This [colorly] mini-van stinks from the other side of the street. You still go closer to the van in order to desperately find some clues. You cover your nose with your arm. The stinks. It smells like a dead animal was left inside. The windows are too dirty to see through. You try to open the front door without success. You try the back door. It opens and some liquid pours out the van on your feet. You almost throw up and gag nervously because of the putrid smell coming from outside the van. You run back to the other side of the street but an still smell the stink from your shoes. You will never go back to this van.[or]This van is [adverbly] dity. Maybe I should limit my examination to visual perception. And you did.[or]A mini-van in a huge town. A small ride in a big pile of trash. You wander around the van, trying to open its doors, but it is locked. Let's search somewhere else.[at random]"
"mailbox"	"mail"	"box"	"[one of]A [adverbly] usual mailbox. No need to check inside: the door is broken open wide, and I can tell you that there sure is no mail in it.[or]A broken mailbox. Its door has been torn off. There still are some papers on the ground. An address with no name. Quail Springs. Reminds me of summer. A heart warms up a bit in these cold streets. Nothing that would get me out of here. Let’s look somewhere else for clues.[or]No one would bother if I check inside. Oh, there is garbagge inside. How surprinsing. I guess that this will teach my curiosity a lesson.[or]There is a [colorly] mailbox on this side of the street. As you open it, it vomit a great amount of letters. Dark yellow envelope, an address with no name, a stamp from an unknown [']SCM law firm[']. They all seem to be the same. They all are the same. There is nothing else in and out the mailbox. Better look somewhere else for some clues.[at random]"
"newspaper"	"journal"	"journal"	"[one of]An abandoned paper in the streets. You read through the titles. News from abroad. Finally a link with the outside world! But you cannot find any informations about where you are. Your enthusiasm drops with the newspaper. You raise your head and look for another clue.[or]Some newspaper is left abandoned in the middle of the street. It pretty old. You cannot read much from it. You cannot even tell if it concern this city or not. Better look for clues somewhere else.[or]Let's see if there is some news on Mrs Johnson affair. This newpaper is one month old. Not a single clue in there. Let's search somewhere else.[or]This newpaper is decomposing. You still bend over and reach out to it, because it might contain some clues on this city, but as soon as you touch it, a cockroach gets out of it. You got scared and start to walk away. Anyway, it was probably too much damaged to read anything on it.[or]Some old dirty newspaper. It might have been of any help if it was not torn apart. You have a quick look at the articles, but nothing seems to be of interest.[at random]"
"coffee cup"	"cup"	"coffee"	"[one of]There still is some warm coffee in this [colorly] cup. Maybe someone is close.[or]Just some garbage in the shape of a coffee cup.[or]The more I observe it, the more I consider this town as a gigantic garbage.[at random]"
"blanket"	"cover"	"cover"	"[one of]This [colorly] blanket probably belong to someone living in those streets. I can't find anyone around though.[or]I sure am cold, but there is noway I will cover myself with such a dirty blanket abandoned in the streets. You still lift it with your right foot to look under it. A few cockroaches leave the blanket. Let's look somewhere else.[or]This is the kind of thing that warms your heart when you have nothing else. A homeless probably left it here.[at random]"
"pile of cardboxes"	"boxes"	"pile"	"[one of]You start searching the cardboxes. One after one. Then this one. And the other. There are still some more. Well you know what? These things are clearly empty.[or]You start searching into the cardboxes and get welcomed by a rat. You promise yourself to stay away from cardboxes in the future.[or]You start emptying one cardbox after the other, but found nothing useful.[at random]"
"cigarette end"	"cigarette"	"fag"	"[one of]This might belong to a dead guy. What am I thinking? I am getting out of here alive. I am getting out of here...[or]There is nothing unusual about a cigarette end in the streets. It seems that it was abandoned long ago.[or]This cigarette end is still smoking. Maybe there is still someone around?[or]Just another garbage in this huge pile of trash.[at random]"

[To increase input comprehension]
A cityDecor has some indexed text called title2.
Understand the title2 property as describing a cityDecor.
A cityDecor has some indexed text called title3.
Understand the title3 property as describing a cityDecor.

[Assigning a Name to each cityDecor]
[We have to make sure that every cityDecor is only used once in each room -- matter of referencing without haecceity]
To name cityDecors:
	repeat with R running through rooms in the City:
		let L be a list of text;
		if the location of the car is R:
			add "car" to L;
		repeat with P running through the list of every cityDecor in R:
			choose a random row in the Table of City Decors;
			[This is to make sure that two cityDecors do not get the same name]
			while "[name entry]" is listed in L:
				choose a random row in the Table of City Decors;
			now the printed name of P is "[name entry]";
			if the printed name of P is listed in {"mini-van", "car", "SUV"}:
				now P is vehiculable;
			if the printed name of P is listed in {"mini-van", "car", "SUV", "pile of cardboxes", "mailbox"}:
				now P is openable;
			if the printed name of P is listed in {"newspaper"}:
				now P is readable;
			now the title2 of P is "[title2 entry]";
			now the title3 of P is "[title3 entry]";
			now the description of P is "[description entry]";
			add "[name entry]" to L;
		[Now this is stupid but is the only way I found to "empty" the list after every room loop...]
		let L be {"empty"}.

[Change rules to seem less mechanized]
Instead of taking something fixed in place (called X):
	if X is non-examined:
		try examining the noun;
		if X is lucky:
			stop the action;
		if X is haunted:
			stop the action;
		if X is unlucky and X is non-haunted:
			say "[decorRejectly][line break]";
	otherwise:
		try examining the noun.





Section 8 - Encounters

[General frame]
Carry out examining a cityDecor (called X):
	if the noun is non-examined:
		[1. Determine luck]
		determine luck of X;
		if X is unlucky:
			if X is non-haunted:
				determine haunt of X;
				if X is non-haunted:
					continue the action;
				if X is haunted:
					stop the action;
			[2. Avoid double haunt]
			if X is haunted:
				continue the action;
		if X is lucky:
			stop the action;
	[if already examined]
	otherwise:
		if X is unlucky:
			say "[one of]I already examined it, and found no clue.[or] I already lost some time examining it.[or]There is no use examining the [noun] twice.[or] I found no clue around that [noun]. There is no need to search there again.[or]I already investigate the [noun], but I got nothing out of it.[at random]";
			stop the action;
		if X is lucky:
			continue the action.

[Set vars for RNG]
ItemRNG is a number that varies.
ItemRNG is usually 0.
MailRNG is a number that varies.
MailRNG is usually 0.

[To determine luck]
To determine luck of (Dec - a cityDecor):
	if the noun is non-examined:
		if the list of readable non-placed cityItem is not empty:
			[1. Mailbox]
			if the printed name of Dec is "mailbox":
				[1.A. Threshold]
				if MailRNG is 3:
					make mailLuck of Dec;
				otherwise:
					[1.B. Random chance]
					if a random chance of 1 in 3 succeeds:
						make mailLuck of Dec;
					otherwise:
						continue the action;
						increase MailRNG by 1;
			[2. Not a Mailbox]
			otherwise:
				[2.A. Threshold]
				if ItemRNG is 4:
					make decLuck of Dec;
				otherwise:
					[2.B Random chance]
					if a random chance of 1 in 6 succeeds:
						make decLuck of Dec;
					otherwise:
						continue the action;
						increase ItemRNG by 1; 
		[If there are no available items]
		otherwise:
			continue the action;
			now MailRNG is 0;
			now ItemRNG is 0.

[To make mailbox lucky]
To make mailLuck of (Dec - a cityDecor):
	let J be a random readable non-placed cityItem;
	say "[one of]You grab the handle and pull on it as hard as possible. This mailbox seems stuck. You try again and start to lose patience. You finally hit the mailbox in anger and the door release. You look inside of it and discover [a J].[no line break][or]The mailbox is damaged and the door seems stuck. However, as you turn around it, you discover a hole on the side. You slide your hand in it and feel something inside. The sharpen edges of the mailbox hurts, but you keep trying to get that thing. You finally make it. You take your hand out of the hole with [a J] in it.[no line break][or]You start searching inside the mailbox. There is a lot of garbage there: empty bottles, plastic bags, chewing gums. Wait. There is something more. [A J].[no line break][at random] What is this? You put it in your pocket, thinking that it might contain some valuable information.[line break]Taken.";
	now the player is carrying J;
	now J is placed;
	now the Dec is examined;
	now the description of the Dec is "This is where I found [the J].";
	now the Dec is lucky;
	now MailRNG is 0.

[To make decors lucky]
To make decLuck of (Dec - a cityDecor):
	let X be a random non-placed cityItem;
	say "[one of]When slowly walking to [the Dec], you step on something. Someone left [a X] here.[or]As you walk toward [the Dec], a glint catch the side of your eye. You start searching in the direction of this sudden glitter, and discover [a X] on the ground.[or]You walk around [the Dec] without finding anything useful. However, as you turn away from it, you see [a X] on the ground.[or]You walk around [the Dec] and examine every piece of it. You realize that your efforts where not in vain as you discover [a X] under [the Dec].[at random]";
	now X is in the location;
	now the Dec is examined;
	now X is placed;
	now the description of the Dec is "This is where I found the [X].";
	now the Dec is lucky;
	set pronouns from X;
	now ItemRNG is 0.

[Set var to avoid same haunt twice]
Lasthaunt is a number that varies.

[To determine haunt]
To determine haunt of (Dec - a cityDecor):
	if a random chance of 1 in 6 succeeds:
		now Dec is haunted;
		let X be a random number between 1 and 5;
		while X is lasthaunt:
			let X be a random number between 1 and 5;
		if X is:
			-- 1: now lasthaunt is 1;
				say "As you approach [the noun], a strange sensation slowly slide on your shoulders. You look at your torso and realize that some sort of voluminous shadow slowly wraps around you. You quickly turn around and try to escape from this presence, but the dark tentacles keep progressing on your body.";
				if the player is carrying a lighter (called X) and present gas of X is not 0:
					say "You grab your lighter and as the flame comes closer to the shadow, the pressure on your shoulder release. You move the flame all around your body until every piece of the shadow disappear. You swear you heard a muted scream before the last piece vanished.[line break]You calm down and go for [the noun].";
					let Y be the present gas of X;
					let Z be Y - 1;
					now the present gas of X is Z;
					continue the action;
				otherwise:
					say "The shadow slowly continues to wrap you as you start to scream in fear. The world is all going to black now. You almost cannot see anymore. You lose consciousness.[line break]You wake up on the ground with a strong headache. What just happened? You look at your shoulders, there is not a single mark of aggression. Am I just losing it? You wonder, realizing that your sanity is decreasing. [The noun] is yet to examine.";
					stop the action;
					decrease sanity;
			-- 2: now lasthaunt is 2;
				say "You approach [the noun], but you hear an atrocious scream a few meters away. A heinous shock breaks you in half as you saw an horrifying figure smiling at you in the shadow. You start to scream as it comes towards you, but when entering the light, it disappears. You calm down. You are back on your feet. But your sanity has dropped.[line break] [The noun] is yet to examine.";
				decrease sanity;
			-- 3: now lasthaunt is 3;
				say "As you walk forward to [the noun], thick large clouds cover the sky and [the location] is plunged into darkness. ";
				if the player is carrying a lighter (called X) and present gas of X is not 0:
					say "You reach for your lighter and raise it high above your head. The shadows around you seem to dissipate in muttering. Soon, the light is back, along with the bright gray of these streets. You do not know what just happened. Maybe you just avoid something bad.[line break]You leave this thought and go for the [noun].";
					let Y be the present gas of X;
					let Z be Y - 1;
					now the present gas of X is Z;
					continue the action;
				otherwise:
					say "Alone in the dark, you try to keep calm, but suddenly ear something on your left. I can feel something near. I can feel something near. It is coming. You start to run blindly. You have to escape. You hit a wall. Soon, on the ground, you lose consciousness.[line break]You wake up and realize that you are not in the same place as before. Someone must have drag you here. What am I going to become?[line break] Your sanity have decreased.";
					decrease sanity;
					now the player is in a random room in the City;
			-- 4: now lasthaunt is 4;
				say "As you walk towards [the noun], something catches your eye on the side of the street. It blinked. It is in that sewer gutter, and your attention is completely clung to it. Your feet leave the road to [the noun] and head for the gutter. The streets are dirty but you went on your knees. The smell, the darkness, the softened tones coming out of it, so many things feel wrong, but you come closer and look straight through the gutter grid. It is too dark to see.";
				if the player is carrying a lighter (called X) and present gas of X is not 0:
					if the list of non-placed cityItem is not empty:
						let Ob be a random non-placed cityItem;
						say "Suddenly, you remember that you are carrying a working lighter. You take it and come closer to the grid bars. You strike the spark wheel, jump and blench as you see some animal run away from the light. Must have been a rat. You look back in the sewer to find the shining item. You suddenly see a [Ob] in there. You reach the [Ob] and put it in your inventory. [The noun] is still yet to examine.";
						now the player is carrying Ob;
						now Ob is placed;
					[this is the counterpart to 'if there is a non-placed cityItem left']
					Otherwise:
						say "Suddenly, you remember that you are carrying a working lighter. You take your [X] and light the sewer entrance. Sadly, there is nothing in there. Maybe you just avoided something that wanted to lured your hand in there. Better not try it. Where was the [noun] again?";
					let Y be the present gas of X;
					let Z be Y - 1;
					now the present gas of X is Z;
					continue the action;
				[This is the counterpart of 'you have a lighter with gas to light the sewer']
				otherwise:
					say "The unidentified thing glows once again. It is so dark in there. You slide your hand between the grid bars although you are not carrying any working lighter to help you to see. One droplet of water falls on your head. You search for the object but cannot feel a thing. You push deeper in the gutter. Another droplet falls. Still nothing. It is still glowing. You are almost there. It is raining now, and the street is getting flooded. Your arm is blocked. The water is up to your mouth now. You know what is coming. You choke once. You fear it. You choke again. You’ll drown here.[line break]But you wake up. Your arm is still in the sewer but easily gets out of it. The rain stopped, you are wet and cold. You wring your shirt. Your head hurts as you realize that the streets are dry as in Summer. What is happening to my sanity?[line break] The [noun] is yet not examined.";
					decrease sanity;
			-- 5: now lasthaunt is 5;
				say "Come to me.[line break] You froze in the middle of the [location], terrified by those words. But there is nothing to see in the direction of this unknown voice. Come to me. What is this and where does it come from? You start to freak out. You turn around in search of a human source. Come to me. Leave me. Leave me. Leave me! You scream in fear. But then everything around you seems to stop and the [location] is filled with silence again. You calm down, but your sanity decreased.[line break] The [noun] is yet not examined.";
				decrease sanity.
		
[This is for knife usage]
Your daughter is a person.
The present sanity of daughter is 5.
DaughterRNG is a number that varies.
DaughterRNG is usually 0.

[Daughter encounter RNG]	
An every turn rule:
	if time of day is after 09:10 AM:
		[1. Threshold]
		if DaughterRNG is 10:
			encouter Daughter;
			now DaughterRNG is 0;
		otherwise:
			[2. Random chance]
			if a random chance of 1 in 20 succeeds:
				encouter Daughter;
				now DaughterRNG is 0;
			otherwise:
				increase DaughterRNG by 1.

[Daughter encounter]
To encouter Daughter:
	if daughter is non-examined:
		say "A whisper in the streets.[line break]Your mind is clear. The building are erased. The ground is not under your feet. There is nothing around you.[line break]Nothing except the fog and that thing.[line break][line break]The thing slowly walks towards you, dragging its left leg as if it was broken.[line break]Its mouth is torn apart.[line break]It screamed too much. But it is all silence now. Only moaning.[line break]It walks towards you.";
		now the daughter is examined;
		say "You run. You run as fast as you can. What was that thing? Who was that? Was that even human? A few seconds passes and you calm down, realizing that you don't know where you are.[line break]Let's hope that I will never see this thing again.";
		now the player is in a random room in the City;
	[counterpart of 'daughter non-examined']
	otherwise:
		say "[one of]It is here. Again. It came back for more. There is no turning back now. The thing is back.[or]Suddenly a noise. It is back. How could it be here again. This thing wants me dead. There is no turning back now.[or]A lurid scream came from the left. The thing is here again. It is all bloody now. It came for more.[or]As you look carefully at the fog, the silhouette of a young girl slowly appears in the distance. It is the thing. Again. You look back to flee but the young girl starts to run towards you in a scream. You understand that there is no way out.[or]She is here. She is here again. When is this going to stop?[or] She is here again. I have to stop this. It is her or me.[stopping]";
		[First condition - knife]
		if the player is carrying a knife:
			if a random chance of 3 in 4 succeeds:
				unless the present sanity of daughter is 1:
					say "[one of]You took your knife out and screamed in anger as you slash with all your strength through the air. The thing groan in pain. As she turn around, you can see a long and deep cut in her back. You feel strengthened but this fight, but wish you never have to encounter this thing again.[or]Before the thing gets to you, you took your knife out and got ready to attack. But the thing now runs and jump on you. You shove the knife right through her torso, but fall on the ground due to its momentum. She tries to beat you on the floor but you riposte with all your strength. You finally take the knife off for a final hit, but the thing stand up and run away. Once again, you got out alive. Better not encountering this thing one more time.[or]You take your knife and start to scream. You are trying your best to find the energy to stand against this thing when every piece of your body wants to leave. You start running around the thing as she was your prey. Luckily, she turn her head right when you decide to attack. You shove your knife in her shoulder and take it out. The thing runs away. You stay strong and determined to continue this journey.[or]The thing tries to hit you but you avoid dodge it. In return you slash your knife with all the strength you have. You try to give a second slash but the thing is already running away.[or]You swing your knife in the air, but it misses the thing. She grab both of your shoulders to eat you. You keep her away with one hand and stab her stomach with the other. The thing release you and run away. You stay a few minutes on the ground, trying to get things straight. You stand up and continue your journey.[or]the thing runs and tries to jump on you but you dodge it. You stab the thing in the back as it fall down on the ground. You take the knife out to give another hit, but the thing hit you back. You fall down and see the thing running away. Your days are not over. Yet.[at random]";
					let X be the present sanity of daughter;
					let Y be X - 1;
					now the present sanity of daughter is Y;
					if the present sanity of daughter is 2:
						say "I never wanted to hurt you Lily. I never.";
				[counterpart of 'daughter sanity > 1']
				otherwise: 
					kill;
			[counterpart of 'lucky hit']
			otherwise:
				say "[one of]The thing gets to you before you are able to get your knife. It bites your left arm and run away with a piece of your flesh in its mouth. Your sanity heavily decrease.[or]You take your knife out and slash through the air, but the thing avoids it. It slashes you in return. You fall on the ground in great pain. Hopefully the thing is running away. Your sanity decrease as you look at the cuts on your body.[or]You try to hurt the thing with your knife but she is too fast. She bites your left calf and run away with a piece of it. Your sanity highly decrease as you look at your leg bleeding. Got to keep going. Got to get out of there alive.[at random]";
				decrease sanity;
				decrease sanity;
		[counterpart of 'have a knife']
		otherwise:
			[Condition on sanity > 1]
			unless the present sanity of the player is 1:
				say "[one of]You try to face the thing walking towards you but your legs are about to break. You take one step back and the thing starts to run. You turn around and run as fast as you can. You have no idea where you are going, and you cry, wishing you will soon wake up from this nightmare.[line break]But you did not wake up. You are lost, somewhere in this City, and your sanity is decreasing.[or]You try to stand in front of the creature but start to run instead. You could swear that you saw thousands of others during your escape, at every corner, in every alley.[line break]You finally stop, completely exhausted. You sanity have decrease.[or]Once again, you cannot stand the thing. Once again, you run. You will never wake up. Your sanity decreased.[stopping]";
				decrease sanity;	
				now the player is in a random room in the City;
			[Counterpart to sanity > 1]
			otherwise:
				murder.






Section 9 - Doors

[For now, game ends at the rusty door]
ro0city is a room.

[In order to have a linking room inside a room, we need to add a direction]
The rusty door is a door.
The rusty door is lockable and locked.
The description of the rusty door is "I know. I know that behind this door is nothing that I could ever imagine, and everything I want to know. I can feel its power. The undergrounds of life, down below the basement of my reality. I can feel it calling me. It has a hole, bleeding. The key to my heart, where is it?".
The rusty door is hidden.
It is inside from ro9city and west of ro0city.
The printed name of ro0city is "a dark corridor".

[End games]
After going in ro0city:
	escape.
Instead of opening the rusty door:
	if the player is carrying the rotten key:
		escape;
	otherwise:
		try examining the rusty door.

[Saying something]
Saying is an action applying to one thing.
Understand "say [something]" as saying.
Understand "scream [something]" as saying.
Carry out saying something (called X):
	if X is the rusty door:
		try examining the rusty door;
	otherwise:
		say "(to yourself)[line break]There is no reply.[line break]".

[Scream]
Screaming is an action applying to one topic.
Understand "scream [text]" as screaming.
Carry out screaming:
	say "(to yourself)[line break]There is no reply.[line break]".

[Because of the description of the parchment]
Understand "B'gnu-Thun" or "b'gnu-thun" or "b'gnu-thun" or "B'gnu-Thun" or "B gnu-Thun" or "B gnu Thun" or "b gnu thun" or "Bgnu-Thun" or "BgnuThun" or "B gnu thun" as the rusty door.

[This is to make the rusty door visible]
Instead of examining the rusty door:
	if the rusty door is non-examined:
		say "As you say these terrible words, the wind intensifies throughout the [location]. With it comes a voice. It speaks an unintelligible tongue. When looking in the opposite direction of the wind, you see an opening. You walk forward as the wind mysteriously tear the fog in half, as if it wanted to show you the way. It leads you to the corner of a high building. At the end of a lousy alley in between decayed walls is a rusty door.";
		now the rusty door is revealed;
		continue the action;
	otherwise:
		continue the action.








Section 10 - Directions

[Viable directions]
Definition: a direction (called X) is viable if the room X from the location is a room.

[Can't go back]
Returning is an action applying to one topic.
Understand "go to [text]" or "go back to [text]" or "return to [text]" or "where is [text]" as returning.
Carry out returning:
	say "[one of]Where was it again? I really can't make up my mind in this town.[or]
	I can't clearly remember... Was it to the West, or to the North? I am loosing my mind in here.[or]
	Let's go back to... Where was it again? Last time, I went [last direction of the player]. Before that was East... or  South? Try to keep focus, I need to get out of this town.[or]
	Where was it already? I really can't make up my mind in this town.[or]
	Wait, where was it already? Last time I moved, I went [last direction of the player], but what have I done before that?[at random]".
	
	
[Understand 'go left' and 'go right']
left is a direction.
right is a direction.

[Possible viable directions]
To say cityObstructly:
	choose a random row in the Table of City obstructions;
	say "[obstruction entry]";
	[make conditions to show (or not) a random viable path]
	let LUnvis be a list of directions;
	let LVis be a list of directions;
	repeat with VDir running through viable directions:
		if VDir is not inside: [to keep rusty door hidden]
			if the room VDir from the location is unvisited:
				add VDir to LUnvis;
			otherwise:
				add VDir to LVis;
	if LUnvis is not empty:
		[this is because I can't 'let X be a random entry of L']
		let X be a random number between 1 and the number of entries in LUnvis;
		let Y be the entry X of LUnvis;
		say " There seems to be a way to the [Y].";
	otherwise:
		if the number of entries in LVis is 1:
			say "This place is a dead end. There is no other way than [LVis].";
		Otherwise:
			say "There seem to be no other way than [LVis].".


Table of City obstructions
obstruction
"A line of high buildings with graffitis on them. Might be factories. You walk along the [citycolorly] facades but every entrance seems stuck or heavily locked. After a little while, you turn around and look for another way."
"Long, never-ending [citycolorly] walls. There are a few broken windows, but they are too high to reach. You start to look around you in search for help.”
"Buildings, fences, barricades, walls, obstacles. There is no way through that mess. Let's try somewhere else."
"A long welded wire fence. It is too high to climb and I have nothing to cut a way through. There is no need losing time here."
"There is no door nor pathway in this direction. The exit must be somewhere else."

To say cityDirectionNorthly:
	choose a random row in the Table of City directions;
	say "[north entry]".

To say cityDirectionSouthly:
	choose a random row in the Table of City directions;
	say "[south entry]".

To say cityDirectionWestly:
	choose a random row in the Table of City directions;
	say "[west entry]".
	
To say cityDirectionEastly:
	choose a random row in the Table of City directions;
	say "[east entry]".

[This is the most horrible table you ever saw, but it is important for two reasons:
First, because it enable to have a sticky random choice per 'examining direction',
Second, because I wasn't able to automatize the 'To say cityDirection...' part, and wanted revenge.]
Table of City directions
north	south	west	east
"The fog in this direction is too dense for you to see through. However, as you turn your head, you can feel the wind blowing from the North, like if it was an invitation to follow this direction."	"There is a crossway to the south. You could try to go there to find some help. This feeling saddened you, but an unknown determination soon straighten up your spine."	"You look at the West through the fog and notice some light in the distance. There must be another street in this direction."	"When looking to the east, you realize that there is a narrow footpath between two buildings. It seems that it leads to somewhere. I think, I think I saw a light through the fog."
"The wind is blowing from the North, despite the thick fog preventing you from seeing anything in this direction. Maybe you should go there anyway."	"It seems that there is [a room south of the location of the player] to the South, although the road leading there is half closed by construction works."	"At the same time you look to the West, the sound of a metallic object falling on the ground is heard in the distance. I should go to the west and investigate."	"Judging from the traffic lights you can saw on the East, this direction is not a dead end."
"As the wind blows from the North, you notice that there is [a room north of the location of the player] in this direction."	"The path seems clear to the South, but the appearance of the neighbourhood in this direction is very unwelcoming."	"You notice that the road to the west seems to meet another road about two undred meters away."	"For a moment, the light wind scatter the fog and you can see [a room east of the location of the player] to the East."

[Rule for 'examine' or 'look' text]
[Note for further development: could define 'a path' from viable direction, and then 'path can be examined or non-examined'.
This would be an improvement when in a square 2x2 room schema: for now, because the room and not the path gets examined,
two different paths to a same room demand only one examine action.]
Instead of examining a direction (called X):
	if X is not listed in {the north, the south, the east, the west, left, right}:
		say "There is nothing in this direction.";
	otherwise:
		if X is listed in {left, right}:
			try going X;
		otherwise:
			if X is not a viable direction:
				say "[cityObstructly]";
			otherwise:
				if the room X of the location of the player is non-examined:
					if X is North:
						say "[cityDirectionNorthly][line break]";
					else if X is South:
						say "[cityDirectionSouthly][line break]";
					else if X is East:
						say "[cityDirectionEastly][line break]";
					else if X is West:
						say "[cityDirectionWestly][line break]";				
					now the room X of the location of the player is examined;
					now the location of the player is examined;
				otherwise:
					say "[one of]There definetly is a way through this direction.[or]I can see [a room north of the location of the player] in this direction.[purely at random]"

[This is used to softly force players to examine rooms before other actions]
[It works with 'going a direction' but not 'going in a direction']
A person has a direction called last direction.
Instead of going a direction (called X):
	if X is left:
		say "Did you meant [']West[']?";
		stop the action;
	if X is right:
		say "Did you meant [']East[']?";
		stop the action;
	if X is a viable direction:
		[this first condition is to avoid examining a return path]
		now last direction of the player is X;
		if the room X of the location of the player is visited:
			continue the action;
		otherwise:
			if the room X of the location of the player is non-examined:
				try examining X;
				now the room X of the location of the player is examined;
				continue the action;
			otherwise:
				continue the action;
	otherwise:
		try examining X.






Section 11 - Word variations

[To vary discourse in room descriptions, create thoughts...]
To say feelingly:
	choose a random row in the Table of City thoughts;
	say "[feeling entry]".
	
Table of City thoughts
feeling
“What is this place and what am I doing here?”
“This town... Do I know this town?[line break]”
“There is no way I get out from here alive. No, no, no, no, no. I am getting out of here. I am. Getting. Out. Of. Here.”
“Have I already been here before?”
“Is that a... it is not.”
“I wonder when was last time someone came here.”
“Maybe this is all just a set-up. Maybe this is serious. This is serious. Focus.”
“Am I even looking for something?”
“This fog. This fog. I will soon wake up. I have. I have to make it. What if this was not a nightmare.”
“How could I have sensations of flashbacks in such a place?”
“The light around you seems to flee the air in silence.”
“You cannot even tell if there is a sky above you. You cannot even tell if you are outside, or just in a jar full of smoke.”



[The following tables are to vary words]
To say sizely:
	choose a random row in the Table of Variations;
	say "[size entry]".
	
To say adverbly:
	choose a random row in the Table of Variations;
	say "[adverb entry]".
	
To say colorly:
	choose a random row in the Table of Variations;
	say "[color entry]".

Table of Variations
size	adverb	color
"small"	"absolutely"	"dark blue"
"large"	"completely"	"mauve"
"great"	"quite"	"mellow"
"short"	"fairly"	"sepia"
"tall"	"pretty"	"black"
"long"	"almost"	"ochre"
"little"	"very"	"carmine"
"compact"	"slightly"	"crimson"
"big"	"certainly"	"violet"
"compact"	"very"	"magenta"
"average"	"absolutely"	"granola"
"long"	"very"	"amber"
"average"	"certainly"	"ruby"


To say judgmently:
	choose a random row in the Table of City Variations;
	say "[judgment entry]".

To say citycolorly:
	choose a random row in the Table of City Variations;
	say "[city color entry]".

Table of City Variations
judgment	city color	buildings adjective
"disgusting"	"gray"	"abandoned"
"ugly"	"fossil gray"	"old"
"nice looking"	"humber"	"fearsome"
"strange"	"harbor gray"	"frightening"
"unusual"	"charcoal"	"dirty"
"pretty old"	"dim gray"	"lousy"
"very old"	"ebony"	"vandalized"
"disgusting"	"midnight blue"	"vast"
"pretty ugly"	"onyx"	"vast"
"broken"	"licorice"	"lousy"

To say decorRejectly:
	choose a random row in the Table of City Discourses;
	say "[decor rejects entry]".

Table of City Discourses
building	remarks	decor rejects
"construction"	"I wonder who left that there."	"I don't want to take that [noun]."
"building"	"Who would ever throw that here?"	"This [noun] is of no use to me."
"industrial site"	"What could I do with that?"	"Do you really think I was going to take that [noun]?"
"construction site"	"I never saw this one before."	"I do not want to take that [noun]."
"manufacturing plant"	"Reminds me of another one."	"I would rather let this [noun] where it lays."
"factory"	"When was that left away?"	"I don't really want to touch that [noun]."
"train station"	"My brother used to have one."	"I really don't need that [noun]."
"houses"	"I wonder who left that there."	"I'll leave it there because it seems pretty useless to me."
"houses"	"You really can find anything in these streets."	"This [noun] is useless to me."
"houses"	"Should I do something with it?"	"There really is no way I take that [noun] in my pocket."


To say startingly:
	choose a random row in the Table of Starting;
	say "[start entry]".

Table of Starting
start
"[one of]The sea. I want to go back to the sea.[line break]
My boat. The children laughing at my side. Running away left. Being unable to open my eyes because of the sun.[line break]
Wet. The waves. Water. Drops. Drops on my face. Wake up.
[line break][line break]
You are lying down on a cold road. You are wet. A few seconds pass as you dry your face off. You first thought it was tears. It must have rained.[line break]
What is this place? You slowly stand up trying to remember where you are, and how you ended up here. Half asleep, you start walking. Maybe you'll find something of use in here. Maybe you'll find a reason to be here.
[or]
Your eyes blink as you slowly reach your face to dry what seems to be water poured all over it. You realize that your clothes are wet and your fingers icy.[line break]
You feel the cold, firm sensation of concrete under your hand. The streets are soaked.[line break]
You slowly stand up on your feet. What have I done? The flash of a headache strikes right through your right hemisphere. It hurts. Got to find some medicine. Got to find a way out... But where am I?[line break]
A cold shivers runs down your spine as you stand up and start your journey...
[or]
They cannot let you do that. Trust me. I am your friend. Am I not? [line break]
Could you please state your name for the Record? [line break]
And who do you think you are? I cannot let you do that. Who is this guy? What is it? [line break]
This is the matter of the State. I won’t let a friend go. I won’t let you. [line break]
In the report it says that you were undercover on February 14, 2014? [line break]
What have I become?
[line break][line break]
It is late night in the middle of this silent street, deeply silent, although your memories are striking like a waltz of thunder. Your head hurts so much. Steady. Steady. [line break]
You come back to your senses. You are laying down on your knees. In these streets... [line break]
What did you come to find? What you are looking for.[line break]
Why did you come here? Because it’s here. [line break]
You cannot make up your mind yet, but you know that it is here, somewhere, in this place.
In this very unknown, and unfamiliar place. You stand up and start to walk with confidence in this mystery.
[purely at random]"








Section 12 - References

[

This work was build on the basis of the following materials:

"Inform 7 Handbook" by Jim Aikin
http://www.musicwords.net/if/I7Handbook8x11.pdf

"Inform 7 Programmer's Manual" by Ron Newcomb
http://www.plover.net/~pscion/Inform%207%20for%20Programmers.pdf

"When in Rome 1: Accounting for Taste" by Emily Short
http://inform7.com/learn/eg/wir1/source.txt

"Inform7 Appendix A"
http://inform7.com/sources/src/stdrules/Woven/Appendix-A.pdf

]







Section 13 - The Game

[Introduce to the game]
After printing the banner text, say "[line break]The Randomized escape is a narrative fiction based on a randomized distribution of rooms, things, text and encounters. Feel free to find the possible commands (they are not randomized and are pretty basic).[line break]Drawing a map while playing makes navigation much easier.[line break]
[line break][line break]------------------------------------------------[line break][line break]
[startingly]
[line break]
"

[Let's build the game!]
When play begins:	
	[-----rando-----]
	[Define regions]
	make City;
	make City links;
	[Place things in City]	
	place cityItems;
	place containers;
	place cityDecors;
	name cityDecors;
	make cityLighters;
	[-----The actual game-----]
	do nothing.




